package ru.yandex.direct.internaltools.tools.turbo.model;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.NumericId;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class TurboAppAddParameters extends InternalToolParameter {

    @NumericId
    @Input(label = "ClientId")
    private Long clientId;

    @NumericId
    @Input(label = "Идентификатор турбо-аппа", required = false)
    private Long turboAppId;

    @Input(label = "MetaContent турбо-аппа", required = false)
    private String metaContent;

    public Long getClientId() {
        return clientId;
    }

    public TurboAppAddParameters withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Long getTurboAppId() {
        return turboAppId;
    }

    public TurboAppAddParameters withTurboAppId(Long turboAppId) {
        this.turboAppId = turboAppId;
        return this;
    }

    public String getMetaContent() {
        return metaContent;
    }

    public TurboAppAddParameters withMetaContent(String metaContent) {
        this.metaContent = metaContent;
        return this;
    }
}
