package ru.yandex.direct.internaltools.tools.uac.model

import ru.yandex.direct.internaltools.core.annotations.input.CheckBox
import ru.yandex.direct.internaltools.core.annotations.input.Input
import ru.yandex.direct.internaltools.core.annotations.input.TextArea
import ru.yandex.direct.internaltools.core.container.InternalToolParameter

class CampaignTeleporterParam : InternalToolParameter() {

    @TextArea
    @Input(
        label = "Id кампании в продакшене",
    )
    var campaignId: Long = 0L

    @CheckBox(checked = false)
    @Input(
        label = "Обновить заявку при её наличии (затирает существующую на DT/TS)",
    )
    @get:JvmName("isUpdateIfExist")
    var updateIfExist: Boolean = false

    @CheckBox(checked = false)
    @Input(
        label = "Поставить в очередь задачу синхронизации объявлений кампании",
    )
    // internal tools ожидает, что поле будет называться queueTaskToUpdateAdsJob, а геттер - isQueueTaskToUpdateAdsJob
    // JvmName к полю применить нельзя, поэтому приходится переименовывать геттер
    @get:JvmName("isQueueTaskToUpdateAdsJob")
    var queueTaskToUpdateAdsJob: Boolean = false
}
