package ru.yandex.direct.internaltools.tools.uac.tool

import ru.yandex.direct.core.entity.uac.converter.UacGrutAssetsConverter
import ru.yandex.direct.core.grut.api.AssetGrut
import ru.yandex.direct.core.grut.api.SitelinkAssetGrut
import ru.yandex.direct.core.grut.api.TextAssetGrut
import ru.yandex.direct.core.grut.api.TitleAssetGrut
import ru.yandex.direct.internaltools.core.exception.InternalToolValidationException
import ru.yandex.grut.objects.proto.client.Schema

fun toAssetGrut(
    tAsset: Schema.TAsset,
    clientId: Long,
): AssetGrut {
    val uacYdbContent = UacGrutAssetsConverter.toUacYdbContent(tAsset)
    if (uacYdbContent != null) {
        return UacGrutAssetsConverter.toAssetGrut(uacYdbContent)
    }

    return when {
        tAsset.spec.hasSitelink() -> SitelinkAssetGrut(
            id = tAsset.meta.id,
            clientId = clientId,
            title = tAsset.spec.sitelink.title,
            href = tAsset.spec.sitelink.href,
            description = if (tAsset.spec.sitelink.hasDescription()) tAsset.spec.sitelink.description else null,
        )
        tAsset.spec.hasText() -> TextAssetGrut(
            id = tAsset.meta.id,
            clientId = clientId,
            text = tAsset.spec.text,
        )
        tAsset.spec.hasTitle() -> TitleAssetGrut(
            id = tAsset.meta.id,
            clientId = clientId,
            title = tAsset.spec.title,
        )
        else -> throw InternalToolValidationException("Unsupported asset type: \"$tAsset\"")
    }
}

