package ru.yandex.direct.internaltools.tools.userblock.model;

import ru.yandex.direct.core.entity.user.model.UsersBlockReasonType;
import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class UserBlockParams extends InternalToolParameter {
    @Input(label = "Список логинов пользователей (в столбик или в строчку через запятую)")
    @TextArea
    private String logins;

    @CheckBox(checked = true)
    @Input(label = "Проверить тиры пользователей")
    private boolean needTierCheck;

    @CheckBox(checked = true)
    @Input(label = "Проверить, что количество активных кампаний ≤ 200")
    private boolean needCampaignsCountCheck;

    @Input(label = "Причина блокировки")
    @Select
    private UsersBlockReasonType blockReasonType;

    @Input(label = "Комментарий")
    @TextArea String blockComment;

    public String getLogins() {
        return logins;
    }

    public void setLogins(String logins) {
        this.logins = logins;
    }

    public boolean isNeedTierCheck() {
        return needTierCheck;
    }

    public void setNeedTierCheck(boolean needTierCheck) {
        this.needTierCheck = needTierCheck;
    }

    public boolean isNeedCampaignsCountCheck() {
        return needCampaignsCountCheck;
    }

    public void setNeedCampaignsCountCheck(boolean needCampaignsCountCheck) {
        this.needCampaignsCountCheck = needCampaignsCountCheck;
    }

    public UsersBlockReasonType getBlockReasonType() {
        return blockReasonType;
    }

    public void setBlockReasonType(UsersBlockReasonType blockReasonType) {
        this.blockReasonType = blockReasonType;
    }

    public String getBlockComment() {
        return blockComment;
    }

    public void setBlockComment(String blockComment) {
        this.blockComment = blockComment;
    }
}
