package ru.yandex.direct.internaltools.tools.userblock.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class UserResult {
    @JsonProperty("Логин")
    private String login;

    @JsonProperty("Статус до")
    private UserStatus statusBefore;

    @JsonProperty("Статус после")
    private UserStatus statusAfter;

    @JsonProperty("Ошибка")
    private String error;

    @JsonProperty("Комментарий")
    private String comment;

    public UserResult(String login) {
        this.login = login;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public UserStatus getStatusBefore() {
        return statusBefore;
    }

    public void setStatusBefore(UserStatus statusBefore) {
        this.statusBefore = statusBefore;
    }

    public UserStatus getStatusAfter() {
        return statusAfter;
    }

    public void setStatusAfter(UserStatus statusAfter) {
        this.statusAfter = statusAfter;
    }

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void appendError(String error) {
        if (this.error == null) {
            this.error = error;
        } else {
            this.error += ";\n";
            this.error += error;
        }
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void appendComment(String comment) {
        if (this.comment == null) {
            this.comment = comment;
        } else {
            this.comment += ";\n";
            this.comment += comment;
        }
    }
}
