package ru.yandex.direct.internaltools.tools.users.model;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class DoNotSendSmsInput extends InternalToolParameter {
    public static final String ACTION_LABEL = "Действие";
    public static final String UID_LABEL = "UID";
    public static final String LOGIN_LABEL = "Логин";

    @Input(label = ACTION_LABEL)
    private DoNotSendSmsAction action;

    @Input(label = UID_LABEL, required = false)
    private Long uid;

    @Input(label = LOGIN_LABEL, required = false)
    private String login;

    public DoNotSendSmsAction getAction() {
        return action;
    }

    public DoNotSendSmsInput withAction(DoNotSendSmsAction action) {
        this.action = action;
        return this;
    }

    public Long getUid() {
        return uid;
    }

    public DoNotSendSmsInput withUid(Long uid) {
        this.uid = uid;
        return this;
    }

    public String getLogin() {
        return login;
    }

    public DoNotSendSmsInput withLogin(String login) {
        this.login = login;
        return this;
    }
}
