package ru.yandex.direct.internaltools.tools.userssegments.model;

import java.util.Arrays;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;

public enum AdShowType {

    START("старт",
            List.of(ru.yandex.direct.core.entity.adgroup.model.AdShowType.START)),
    FIRST_QUARTILE("просмотрена четверть",
            List.of(ru.yandex.direct.core.entity.adgroup.model.AdShowType.FIRST_QUARTILE)),
    MIDPOINT("просмотрена половина",
            List.of(ru.yandex.direct.core.entity.adgroup.model.AdShowType.MIDPOINT)),
    THIRD_QUARTILE("просмотрено три четверти,",
            List.of(ru.yandex.direct.core.entity.adgroup.model.AdShowType.THIRD_QUARTILE)),
    COMPLETE("закончен просмотр",
            List.of(ru.yandex.direct.core.entity.adgroup.model.AdShowType.COMPLETE)),
    ALL("все",
            Arrays.asList(ru.yandex.direct.core.entity.adgroup.model.AdShowType.values()));

    private final String description;
    private final List<ru.yandex.direct.core.entity.adgroup.model.AdShowType> coreTypes;

    AdShowType(String description, List<ru.yandex.direct.core.entity.adgroup.model.AdShowType> coreTypes) {
        this.description = description;
        this.coreTypes = coreTypes;
    }

    @JsonIgnore
    public List<ru.yandex.direct.core.entity.adgroup.model.AdShowType> getCoreTypes() {
        return coreTypes;
    }

    @JsonValue
    public String getDescription() {
        return description;
    }

}
