package ru.yandex.direct.internaltools.tools.userssegments.model;

import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.annotations.input.DateTime;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@ParametersAreNonnullByDefault
public class UsersSegmentsUpdateTimeResetParameters extends InternalToolParameter {

    public static final String ADGROUPS_LABEL = "Список id групп, через запятую";

    @Select
    @Input(label = "Тип просмотра (или все типы)")
    private AdShowType adShowType;

    @TextArea
    @Input(label = ADGROUPS_LABEL)
    private String adGroups;

    @Input(label = "Новое значение last_successful_update_time")
    @DateTime(now = true)
    private LocalDateTime newLastSuccessfulUpdateTime;

    public String getAdGroups() {
        return adGroups;
    }

    public void setAdGroups(String adGroups) {
        this.adGroups = adGroups;
    }

    public void setNewLastSuccessfulUpdateTime(LocalDateTime newLastSuccessfulUpdateTime) {
        this.newLastSuccessfulUpdateTime = newLastSuccessfulUpdateTime;
    }

    public LocalDateTime getNewLastSuccessfulUpdateTime() {
        return newLastSuccessfulUpdateTime;
    }

    public AdShowType getAdShowType() {
        return adShowType;
    }

    public void setAdShowType(AdShowType adShowType) {
        this.adShowType = adShowType;
    }

}
