package ru.yandex.direct.internaltools.tools.widget;

import java.util.Collections;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolMassResult;
import ru.yandex.direct.internaltools.core.container.InternalToolResult;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.tools.widget.model.WidgetCodeForPartnersParams;
import ru.yandex.direct.internaltools.tools.widget.model.WidgetCodeForPartnersResponse;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Tool(
        name = "Генерация кода виджета Директа для партнёров",
        label = "generate_widget_code_for_partners",
        description = "В поле «Идентификатор партнёра из Я.Дистрибуции (WidgetPartnerID)» вставьте идентификатор, " +
        "полученный в Яндекс.Дистрибуции. Система сгенерирует код виджета с нужным ID для вставки на сайт партнёра.",
        consumes = WidgetCodeForPartnersParams.class,
        type = InternalToolType.REPORT)
@Action(InternalToolAction.SHOW)
@Category(InternalToolCategory.OTHER)
@AccessGroup({
        InternalToolAccessRole.SUPER,
        InternalToolAccessRole.DEVELOPER,
        InternalToolAccessRole.SUPERREADER,
        InternalToolAccessRole.MANAGER})
@ParametersAreNonnullByDefault
public class WidgetCodeForPartners implements BaseInternalTool<WidgetCodeForPartnersParams> {

    @Override
    public ValidationResult<WidgetCodeForPartnersParams, Defect> validate(
            WidgetCodeForPartnersParams params) {

        ItemValidationBuilder<WidgetCodeForPartnersParams, Defect> vb =
                ItemValidationBuilder.of(params);
        vb
                .item(params.getWidgetPartnerId(), "widgetPartnerId")
                .check(notNull());

        return vb.getResult();
    }

    @Override
    public InternalToolResult process(WidgetCodeForPartnersParams params) {
        return new InternalToolMassResult<>(Collections.singletonList(
                new WidgetCodeForPartnersResponse(params.getWidgetPartnerId())));
    }
}
