package ru.yandex.direct.internaltools.tools.widget.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

@ParametersAreNonnullByDefault
public class WidgetCodeForPartnersResponse {

    private static final String RESPONSE_TEMPLATE =
            "<html>\n" +
                    "<head></head>\n" +
                    "<body>\n" +
                    "    <div id=\"my-container\"></div>\n" +
                    "    <script src=\"https://yastatic.net/s3/direct-frontend/uac-widget/partner-script.js\"></script>\n" +
                    "    <script>\n" +
                    "        window.YaMasterWidget.init({\n" +
                    "            container: document.querySelector('#my-container'),\n" +
                    "            partnerId: %s\n" + // здесь будет widgetPartnerId
                    "\n" +
                    "        });\n" +
                    "    </script>\n" +
                    "</body>\n" +
                    "</html>\n";

    @JsonProperty("Widget Code")
    @Enrich(InternalToolDetailKey.HTML_PRETTIFY)
    private String response;

    public WidgetCodeForPartnersResponse(Long widgetPartnerId) {
        this.response = String.format(RESPONSE_TEMPLATE, widgetPartnerId);
    }

    public String getResponse() {
        return response;
    }
}
