package ru.yandex.direct.internaltools.tools.yql

import java.time.LocalDateTime
import ru.yandex.direct.internaltools.core.annotations.input.CheckBox
import ru.yandex.direct.internaltools.core.annotations.input.DateTime
import ru.yandex.direct.internaltools.core.annotations.input.Input
import ru.yandex.direct.internaltools.core.annotations.input.Select
import ru.yandex.direct.internaltools.core.container.InternalToolParameter
import ru.yandex.direct.ytwrapper.model.YtCluster

class YqlStatParam : InternalToolParameter() {

    @DateTime
    @Input(label = "Время начала")
    lateinit var from: LocalDateTime

    @DateTime
    @Input(label = "Время завершения")
    lateinit var to: LocalDateTime

    @Select
    @Input(label = "Кластер")
    lateinit var cluster: YtCluster

    @CheckBox(checked = false)
    @Input(label = "Только топ-20 запросов")
    @get:JvmName("isNeedOnlyTop")
    var needOnlyTop: Boolean = false
}

