package ru.yandex.direct.internaltools.tools.yql

import java.time.LocalDateTime
import com.fasterxml.jackson.annotation.JsonIgnore
import com.fasterxml.jackson.annotation.JsonProperty
import ru.yandex.direct.internaltools.core.annotations.output.Enrich
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey

data class YqlStatResult(
    @field:JsonProperty("Название запроса")
    val title: String,

    @field:JsonProperty("Статус")
    val status: String,

    @field:JsonProperty("Время начала")
    val createdAt: LocalDateTime,

    @field:JsonProperty("Время завершения")
    val updatedAt: LocalDateTime,

    @field:JsonProperty("Длительность (минуты)")
    val duration: Int,

    @field:JsonProperty("Ссылка")
    @Enrich(InternalToolDetailKey.COMMON_LINK_REPLACE)
    val link: String,

    @field:JsonProperty("Число таких же запросов")
    val count: Int? = 1,

    @JsonIgnore
    val operationsCount: Int,

    @JsonIgnore
    val cpu: Int,
) {
    @get:JsonProperty("Число YT-операций")
    private val resOperationsCount: String
        get() = if (operationsCount < 0) "-" else operationsCount.toString()

    @get:JsonProperty("Число ядер")
    private val resCpu: String
        get() = if (cpu < 0) "-" else cpu.toString()
}
