package ru.yandex.direct.juggler.check.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.stereotype.Component;

import ru.yandex.direct.env.TypicalEnvironment;
import ru.yandex.direct.juggler.check.DirectNumericCheck;
import ru.yandex.direct.juggler.check.model.CheckTag;
import ru.yandex.direct.utils.Condition;

/**
 * Для задач и объектов {@link DirectNumericCheck}, помеченных этой аннотацией,
 * будет автоматически заведен juggler-мониторинг
 */
@Documented
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Repeatable(JugglerChecks.class)
@Component
public @interface JugglerCheck {
    /**
     * Аннотация для удобного задания ttl проверок по частям:
     * {@link #days}, {@link #hours}, {@link #minutes}, {@link #seconds}
     */
    @Retention(RetentionPolicy.RUNTIME)
    @interface Duration {
        int days() default 0;

        int hours() default 0;

        int minutes() default 0;

        int seconds() default 0;
    }

    /**
     * TTL мониторинга (проверка зажигается в NO_DATA спустя это время после последнего сигнала)
     */
    Duration ttl() default @Duration(minutes = 10);

    /**
     * Класс (реализующий {@link Condition}), содержащий логику "нужно ли использовать эту проверку".
     * Должен быть помечен аннотацией {@link org.springframework.stereotype.Component},
     * чтобы быть доступным в виде бина в текущем контексте.
     *
     * @return класс с логикой если был задан, или {@link TypicalEnvironment}
     */
    Class<? extends Condition> needCheck() default TypicalEnvironment.class;

    /**
     * juggler-теги проверки
     */
    CheckTag[] tags() default {};

    /**
     * Нотификации для текущей проверки
     */
    OnChangeNotification[] notifications() default {};

    /**
     * Полезные ссылки для отображения в интерфейсе джагглера для данной проверки
     */
    Url[] urls() default {};
}
