package ru.yandex.direct.juggler.check.annotation;

import ru.yandex.direct.ansiblejuggler.model.notifications.ChangeType;
import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.model.NotificationRecipient;

public @interface OnChangeNotification {
    /**
     * Получатели уведомлений
     */
    NotificationRecipient[] recipient();

    /**
     * Способ доставки уведомления, по умолчанию смс
     */
    NotificationMethod[] method() default {NotificationMethod.SMS};

    /**
     * Изменения чего нужно сопровождать нотификацией, по умолчанию - статуса
     */
    ChangeType type() default ChangeType.STATUS;

    /**
     * Статусы, для которых срабатывает нотификация. По умолчанию - только CRIT
     */
    JugglerStatus[] status() default {JugglerStatus.CRIT};
}
