package ru.yandex.direct.juggler.check.checkinfo;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.ansiblejuggler.PlaybookBuilder;
import ru.yandex.direct.utils.Condition;

@ParametersAreNonnullByDefault
public interface BaseJugglerCheckInfo {

    /**
     * Получить класс, обрабатывающий применимость проверки в текущем окружении
     */
    Class<? extends Condition> getEnvironmentConditionClass();

    /**
     * Получить название сервиса
     */
    String getServiceName();

    /**
     * Добавить проверку в ansible-плейбук
     */
    void addCheckToPlaybook(PlaybookBuilder builder);
}
