package ru.yandex.direct.juggler.check.checkinfo;

import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.direct.ansiblejuggler.PlaybookBuilder;
import ru.yandex.direct.juggler.check.DirectNumericCheck;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;

/**
 * Контейнер с информацией, необходимой для создания шаблона числовой juggler-проверки
 */
public class NumericCheckInfo extends AnnotationBasedJugglerCheckInfo {
    private final DirectNumericCheck numericCheck;
    private final String service;
    private final String environmentName;

    public NumericCheckInfo(JugglerCheck annotation, DirectNumericCheck numericCheck, String environmentName) {
        super(annotation);

        this.numericCheck = numericCheck;
        this.environmentName = environmentName;
        service = getNameWithEnv(numericCheck.getServiceName(), environmentName);
    }

    public static String getNameWithEnv(String name, String environmentName) {
        return String.format("%s.%s", name, environmentName);
    }

    @Override
    public String getServiceName() {
        return service;
    }

    @Override
    public void addCheckToPlaybook(PlaybookBuilder builder) {
        ru.yandex.direct.ansiblejuggler.model.checks.JugglerCheck jugglerCheck;

        List<String> checks = numericCheck.getRawServiceNames().stream()
                .map(n -> getNameWithEnv(n, environmentName))
                .collect(Collectors.toList());
        jugglerCheck = builder.addNumericMultiServicesCheck(numericCheck.getHost(), checks, service, getTTL());

        getNotifications().forEach(jugglerCheck::withNotification);
        getTags().forEach(t -> jugglerCheck.withTag(t.getName()));
    }
}
