package ru.yandex.direct.juggler.check.configuration;

import java.util.Collections;

import org.asynchttpclient.AsyncHttpClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

import ru.yandex.direct.common.configuration.CommonConfiguration;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.config.EssentialConfiguration;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.env.EnvironmentTypeProvider;
import ru.yandex.direct.juggler.AsyncHttpJugglerClient;
import ru.yandex.direct.juggler.JugglerAsyncMultiSender;

/**
 * Конфигурация juggler-проверок
 */
@Configuration
@Import({
        EssentialConfiguration.class,
        CommonConfiguration.class
})
@ComponentScan(
        basePackages = "ru.yandex.direct.juggler.check",
        excludeFilters = @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION)
)
public class JugglerCheckConfiguration {
    public static final String ENVIRONMENT_TYPE_PROVIDER_BEAN_NAME = "environmentTypeProvider";

    /**
     * Определитель текущего типа окружения. Используем спринговый бин.
     */
    @Bean(ENVIRONMENT_TYPE_PROVIDER_BEAN_NAME)
    public EnvironmentTypeProvider environmentTypeProvider(EnvironmentType environmentType) {
        return () -> environmentType;
    }

    @Bean
    @Lazy
    JugglerAsyncMultiSender jugglerClient(DirectConfig directConfig, AsyncHttpClient asyncHttpClient) {
        String jugglerUrl = directConfig.getBranch("juggler").getString("eventsGateway");
        return new JugglerAsyncMultiSender(Collections.singletonList(
                new AsyncHttpJugglerClient(jugglerUrl, true, asyncHttpClient)
        ));
    }
}
