package ru.yandex.direct.juggler.check.model;

public enum CheckTag {
    /**
     * Этим тегом размечаем мониторинги, на которых смотрим в регрессии Jobs.
     * Сюда не должны попадать редко или долго выполняющиеся задачи.
     * Интервал мониторинга должен быть меньше 12 часов, а лучше - всего несколько.
     * <p>
     * Перед добавление этого тега на своим проверки - посоветуйтесь с ppalex@.
     */
    JOBS_RELEASE_REGRESSION("direct_jobs_release_regression"),

    /**
     * Для проверок на работоспособность самого шедулера
     */
    JOBS_SCHEDULER("direct_jobs_scheduler"),

    /**
     * Для проверок на работоспособность yql выгрузок (PpcDataExportJob)
     */
    PPC_DATA_EXPORT_JOB("direct_ppc_data_export_job"),

    /**
     * Для проверок, как-то связанных с YT: квоты, работа job'ов по загрузке всего
     */
    YT("direct_yt"),
    /**
     * Для проверок за которыми следит "Группа разработки внутренних систем Директа"
     *
     * @see <a href="https://staff.yandex-team.ru/departments/yandex_monetize_search_direct_interface_sprav/">участники</a>
     */
    GROUP_INTERNAL_SYSTEMS("direct_group_internal_systems"),

    /**
     * Для нотификаций на время разработки/отладки используйте явное правило нотификации на логин,
     * как описано в документации: https://docs.yandex-team.ru/direct-dev/guide/dev/jobs-monitoring#onejob-notifications
     *
     * Затем передайте джобу в централизованный мониторинг app-duty:
     * https://docs.yandex-team.ru/direct-dev/concepts/dev/jobs-monitoring#stages
     *
     * @see <a href="https://staff.yandex-team.ru/departments/yandex_monetize_search_direct_interface_dep01717/">участники</a>
     */
    @Deprecated
    DIRECT_PRODUCT_TEAM("direct_product_team"),
    /**
     * Для проверок, за которыми следит "Группа разработки API к Директу"
     *
     * @see <a href="https://staff.yandex-team.ru/departments/yandex_monetize_search_direct_interface_dirapi_api/">участники</a>
     */
    DIRECT_API_TEAM("direct_group_api"),
    /**
     * Для проверок, за которыми следит "Группа серверной разработки в Санкт-Петербурге"
     *
     * @see <a href="https://staff.yandex-team.ru/departments/yandex_monetize_search_direct_interface_dep38392_dep47986/>участники</a>
     */
    DIRECT_SPB_SERVER_SIDE_TEAM("direct_spb_server_side"),
    /**
     * Для проверок, за которыми следят разработчики Calltracking'а
     */
    DIRECT_CALLTRACKING("direct_calltracking"),

    /**
     * Все бросать и бежать чинить, хотфиксить и т.п. силами app-duty.
     * По тегу собирается верхнеуровневый агрегат, состоящий из всех им размеченных джоб.
     */
    DIRECT_PRIORITY_0("direct_priority_0"),

    /**
     * Тег для джоб из класса критичности PRIORITY_0, мониторинг которых шумит.
     * Нужно для временного вынесения из DIRECT_PRIORITY_0, чтобы шум не мешал реагировать на реальные поломки.
     */
    DIRECT_PRIORITY_0_UNSTABLE("direct_priority_0_unstable"),

    /**
     * Чинить в течение суток под присмотром app-duty.
     * По тегу собирается верхнеуровневый агрегат, состоящий из всех им размеченных джоб.
     */
    DIRECT_PRIORITY_1("direct_priority_1"),

    /**
     * Тег для джоб из класса критичности PRIORITY_1, которые еще не готовы к передаче в дежурство,
     * например из-за отсутствия документации.
     */
    DIRECT_PRIORITY_1_NOT_READY("direct_priority_1_not_ready"),

    /**
     * Чинить в течение недели силами команды разработки или zbp.
     * По тегу собирается верхнеуровневый агрегат, состоящий из всех им размеченных джоб.
     */
    DIRECT_PRIORITY_2("direct_priority_2"),

    /**
     * Все что связано с модерацией.
     * По тегу собирается верхнеуровневый агрегат, состоящий из всех им размеченных джоб.
     */
    DIRECT_MODERATION("direct_moderation"),

    /**
     * Все что связано с транспортом в БК.
     * По тегу собирается верхнеуровневый агрегат, состоящий из всех им размеченных джоб.
     */
    DIRECT_BS_EXPORT("direct_bs_export");

    private final String name;

    CheckTag(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }
}
