package ru.yandex.direct.juggler.check.model;

public enum NotificationRecipient {
    CHAT_API_MONITORING("APIMonitoring"),
    CHAT_API_CLEAN_MONITORING("GroupAPIMonitoring"),
    CHAT_INTERNAL_SYSTEMS_MONITORING("DISMonitoring"),
    CHAT_DIRECT_BILL_AGG("direct-bill-agg"),
    CHAT_DIRECT_BS_TRANSPORT_YT_MONITORING("BsTransportYtMonitoring"),
    CHAT_UC_API_MONITORING("UCApiMonitoring"),
    CHAT_CAMPAIGN_COPY_MONITORING("DirectCampaignCopyErrors"),
    CHAT_CONVERSION_CENTER_BACK("conversion-center-back"),
    LOGIN_PPALEX("ppalex"),
    LOGIN_MAXLOG("maxlog"),
    LOGIN_PAVRYABOV("pavryabov"),
    LOGIN_BUHTER("buhter"),
    LOGIN_XY6ER("xy6er"),
    LOGIN_AJKON("ajkon"),
    LOGIN_SANTAMA("santama"),
    LOGIN_KUHTICH("kuhtich"),
    LOGIN_HRUSTYASHKO("hrustyashko"),
    LOGIN_SNIRINN("snirinn"),
    LOGIN_GERDLER("gerdler"),
    LOGIN_DIMITROVSD("dimitrovsd"),
    LOGIN_IVATKOEGOR("ivatkoegor"),
    LOGIN_AMMSAID("ammsaid"),
    LOGIN_ZAKHAR("zakhar"),
    LOGIN_KOZOBRODOV("kozobrodov"),
    LOGIN_EBOGUSLAVSKAYA("eboguslavskaya"),
    LOGIN_ALEX_KULAKOV("alex-kulakov"),
    LOGIN_DARKKEKS("darkkeks"),
    LOGIN_ANDREYPAV("andreypav"),
    LOGIN_SIVKOV("sivkov"),
    LOGIN_ELWOOD("elwood"),
    LOGIN_OXID("oxid"),
    LOGIN_A_DUBOV("a-dubov"),
    LOGIN_DMITANOSH("dmitanosh"),
    LOGIN_MSPIRIT("mspirit"),
    LOGIN_PALASONIC("palasonic"),
    LOGIN_MREDOR("mredor"),
    LOGIN_PAVELKATAYKIN("pavelkataykin"),
    LOGIN_GUTSOLK("gutsolk"),
    LOGIN_OVAZHNEV("ovazhnev"),
    LOGIN_MEXICANO("mexicano"),
    LOGIN_SSDMITRIEV("ssdmitriev"),
    LOGIN_IAM1("iam-1"),
    LOGIN_NINAZHEVTYAK("ninazhevtyak"),
    LOGIN_TELEPORT("teleport"),
    LOGIN_RSHAKIROVA("r-shakirova"),
    LOGIN_KUVSHINOV("kuvshinov"),
    LOGIN_VAMENSHOV("vamenshov"),
    LOGIN_NBAHOB("nbahob"),
    LOGIN_A_BELIAKOV("a-beliakov"),
    LOGIN_STASIS93("stasis93"),
    LOGIN_VOLODSKIKH("volodskikh"),
    LOGIN_AREVOLUTION("arevolution"),
    LOGIN_DLYANGE("dlyange"),
    LOGIN_KHUZINAZAT("khuzinazat"),
    LOGIN_ALI_AL("ali-al"),
    LOGIN_BABASHEV("babashev"),
    LOGIN_MUNIRA("munira"),
    ;

    private final String name;

    NotificationRecipient(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public static NotificationRecipient fromName(String name) {
        for (NotificationRecipient recipient : NotificationRecipient.values()) {
            if (recipient.name.equals(name)) {
                return recipient;
            }
        }
        throw new IllegalArgumentException(name);
    }
}
