package ru.yandex.direct.logviewercore.domain.ppclog;

import java.sql.Timestamp;

@LogTable(tableName = "binlog_queries_v2",
        logTimeColumn = "datetime",
        logDateColumn = "date",
        reqidColumn = "reqid",
        traceIdColumn = "trace_id",
        logName = "binlog_queries_v2",
        desc = "Лог пишущих запросов в БД (из Logshatter)",
        additionalSort = {"gtid_scn", "query_seq_num"}
)
@SuppressWarnings({"MemberName", "checkstyle:visibilitymodifier"})
public class BinlogQueriesV2 extends LogRecord {
    public Timestamp datetime;

    public String source;

    public String service;
    public String method;

    @LogField(hidden = true)
    public String gtid;
    @LogField(hidden = true)
    public String gtid_src;
    @LogField(hidden = true)
    public long gtid_scn;

    @LogField(hidden = true)
    public long query_seq_num;

    @LogField(heavy = true)
    public String query;

    @LogField(selective = true)
    public long reqid;

    @LogField(strictlyHidden = true)
    public long trace_id;
}
