package ru.yandex.direct.logviewercore.domain.ppclog;

import java.sql.Timestamp;

@LogTable(tableName = "binlog_rows_v2",
        arrayJoin = "row",
        logTimeColumn = "datetime",
        logDateColumn = "date",
        reqidColumn = "reqid",
        traceIdColumn = "trace_id",
        logName = "binlog_rows_fields_v2",
        desc = "Лог изменения строк в БД по полям (из Logshatter)",
        additionalSort = {"gtid_scn", "query_seq_num"}
)
@SuppressWarnings({"MemberName", "checkstyle:visibilitymodifier"})
public class BinlogRowsFieldsV2 extends LogRecord {
    public Timestamp datetime;

    public String source;

    @LogField(hidden = true)
    public String db;
    public String table;

    public String service;
    public String method;

    @LogField(hidden = true)
    public String primary_key_schema;
    public String primary_key;

    public String operation;

    @LogField(hidden = true)
    public String gtid;
    @LogField(hidden = true)
    public String gtid_src;
    @LogField(hidden = true)
    public long gtid_scn;

    @LogField(hidden = true)
    public long query_seq_num;
    @LogField(hidden = true)
    public long change_seq_num;

    @LogField(columnName = "row.name")
    public String col_name;
    @LogField(columnName = "row.value")
    public String col_value;
    @LogField(columnName = "row.is_null")
    public String col_is_null;

    @LogField(selective = true)
    public long reqid;

    @LogField(strictlyHidden = true)
    public long trace_id;
}
