package ru.yandex.direct.logviewercore.domain.ppclog;

import java.sql.Timestamp;

import ru.yandex.direct.logviewercore.service.virtual.EssLogicObjectColumn;

@LogTable(tableName = "ess_logic_objects",
        logTimeColumn = "binlog_time",
        logDateColumn = "binlog_date",
        reqidColumn = "reqid",
        logName = "ess_logic_objects"
)
@SuppressWarnings({"unused", "MemberName", "checkstyle:visibilitymodifier"})
public class EssLogicObjects extends LogRecord {
    public Timestamp binlog_time;
    public String topic;
    public String source;

    @LogField(hidden = true)
    public Long seqNo;

    @LogField(columnName = "logic_object.attr", hidden = true)
    public String[] logic_object_attr;

    @LogField(columnName = "logic_object.value", hidden = true)
    public String[] logic_object_value;

    @LogField(virtual = EssLogicObjectColumn.class)
    public String logic_object;

    @LogField(hidden = true)
    public String gtid;

    @LogField(selective = true)
    public long reqid;

}
