package ru.yandex.direct.logviewercore.domain.ppclog;

import java.sql.Timestamp;

@LogTable(tableName = "ess_logic_objects",
        arrayJoin = "logic_object",
        logTimeColumn = "binlog_time",
        logDateColumn = "binlog_date",
        reqidColumn = "reqid",
        logName = "ess_logic_objects attrs"
)
@SuppressWarnings({"unused", "MemberName", "checkstyle:visibilitymodifier"})
public class EssLogicObjectsAttrs extends LogRecord {
    public Timestamp binlog_time;
    public String topic;
    public String source;
    @LogField(hidden = true)
    public Long seqNo;

    @LogField(columnName = "logic_object.attr")
    public String logic_object_attr;

    @LogField(columnName = "logic_object.value")
    public String logic_object_value;

    @LogField(hidden = true)
    public String gtid;

    @LogField(selective = true)
    public long reqid;

}
