package ru.yandex.direct.logviewercore.domain.ppclog;

import java.sql.Timestamp;

@LogTable(
        tableName = "messages_testing_api",
        logName = "messages_grut_testing_api",
        traceIdColumn = "trace_id",
        desc = "Логи GrUT",
        additionalSort = {"time_ns"},
        logDateColumn = "date",
        logTimeColumn = "time",
        allowAccessFor = {LogTable.SCOPE_DIRECT, LogTable.SCOPE_GRUT}
)
@SuppressWarnings({"MemberName", "checkstyle:visibilitymodifier"})
public class GrutLogMessagesTestingApiRecord extends LogRecord {
    public Timestamp time;
    @LogField(hidden = true)
    public long time_ns;

    public String stage;
    public String service;
    public String host;

    public String trace_id;
    public String thread_name;
    public String fiber_id;

    public String level;
    public String category;

    public String message;
}
