package ru.yandex.direct.logviewercore.domain.ppclog;

import java.sql.Timestamp;

import ru.yandex.direct.logviewercore.service.virtual.JavaThreaddumpThreadStacktraceColumn;

@LogTable(tableName = "java_threaddump",
        arrayJoin = "thread",
        logName = "java_threaddump_threads"
)
@SuppressWarnings({"MemberName", "checkstyle:visibilitymodifier"})
public class JavaThreaddumpThread extends LogRecord {
    public Timestamp log_time;

    public String host;
    public long pid;

    public String service;

    @LogField(hidden = true)
    public String header;
    @LogField(hidden = true)
    public String footer;

    @LogField(columnName = "thread.id", hidden = true)
    public long thread_id;

    @LogField(columnName = "thread.name", hidden = true)
    public String thread_name;

    @LogField(columnName = "thread.is_daemon", hidden = true)
    public int thread_is_daemon;

    @LogField(columnName = "thread.status", hidden = true)
    public String thread_status;

    @LogField(columnName = "thread.state", hidden = true)
    public String thread_state;

    @LogField(columnName = "thread.header", hidden = true)
    public String thread_header;

    @LogField(columnName = "thread.stacktrace", hidden = true)
    public String thread_stacktrace;

    @LogField(virtual = JavaThreaddumpThreadStacktraceColumn.class)
    public String full_stacktrace;
}
