package ru.yandex.direct.logviewercore.domain.ppclog;

import java.sql.Timestamp;

import ru.yandex.direct.logviewercore.service.virtual.ApplicationNameColumn;

@LogTable(tableName = "ppclog_api",
        logName = "ppclog_api",
        reqidColumn = "reqid",
        desc = "Requests to Direct.API",
        encodingBroken = false
)
@SuppressWarnings({"MemberName", "checkstyle:visibilitymodifier"})
public class LogApiRecord extends LogRecord {
    public Timestamp log_time;

    @LogField(desc = "uid or login of operator")
    public long uid;
    public long[] cluid;
    public long[] cid;

    public String cmd;

    public float runtime;

    @LogField(hidden = true)
    public String ip;

    @LogField(heavy = true)
    public String param;
    public int http_status;
    public String error_detail;

    @LogField(selective = true)
    public long reqid;

    @LogField(hidden = true)
    public long units;
    @LogField(hidden = true)
    public String units_stats;

    @LogField(hidden = true)
    public int api_version;
    public String _interface;
    @LogField(hidden = true)
    public String application_id;
    @LogField(hidden = true, virtual = ApplicationNameColumn.class)
    public String application_name;

    @LogField(hidden = true)
    public String response;
    @LogField(hidden = true)
    public long[] response_ids;

    @LogField(hidden = true)
    public String host;
    @LogField(hidden = true)
    public long proc_id;
    @LogField(hidden = true)
    public String source;
}
