package ru.yandex.direct.logviewercore.domain.ppclog;

import java.sql.Timestamp;

@LogTable(
        tableName = "awacs_l7_logs",
        logName = "awacs_l7_logs",
        desc = "Logs from awacs balancers"
)

@SuppressWarnings({"MemberName", "checkstyle:visibilitymodifier"})
public class LogAwacs extends LogRecord {

    public Timestamp log_time;

    public String log_uid;

    @LogField(hidden = true)
    public Long timestamp_us;

    public String iso_eventtime;

    public Long timestamp;

    @LogField(columnName = "domain")
    public String vhost;

    public String method;

    @LogField(columnName = "request")
    public String req_uri;

    public Float process_time;

    public Long status;

    public String reason;

    public String request_id;

    public String yandexuid;

    public String workflow;

    public String headers;

    @LogField(hidden = true)
    public String cookies;

    public String client_ip;

    @LogField(hidden = true)
    public int client_port;

    @LogField(hidden = true)
    public String balancer_hostname;

    @LogField(hidden = true)
    public String upstream;

    @LogField(hidden = true)
    public String report_uuids;

}
