package ru.yandex.direct.logviewercore.domain.ppclog;

import java.sql.Timestamp;

@LogTable(tableName = "campaign_balance",
        logName = "campaign_balance",
        reqidColumn = "reqid",
        desc = "Alter-ego for logbalance"
)
@SuppressWarnings({"MemberName", "checkstyle:visibilitymodifier"})
public class LogCampaignBalanceRecord extends LogRecord {

    public Timestamp log_time;

    @LogField(selective = true)
    public long reqid;

    @LogField(selective = true)
    public String tid;

    public long ClientID;

    public long cid;

    public String type;

    public String currency;

    @LogField(scale = 1_000_000)
    public long sum;

    @LogField(scale = 1_000_000)
    public long sum_delta;

    @LogField(scale = 1_000_000)
    public long sum_balance;

    @LogField(hidden = true)
    public String service;

    @LogField(hidden = true)
    public String method;

    @LogField(hidden = true)
    public String host;

    @LogField(hidden = true)
    public String ip;
}
