package ru.yandex.direct.logviewercore.domain.ppclog;

import java.sql.Timestamp;

import ru.yandex.direct.logviewercore.service.virtual.LogCmdParamsRawColumn;
import ru.yandex.direct.logviewercore.service.virtual.TvmServiceNameColumn;

@LogTable(
        tableName = "ppclog_cmd",
        logName = "ppclog_cmd",
        reqidColumn = "reqid",
        traceIdColumn = "trace_id",
        encodingBroken = false
)
@SuppressWarnings({"MemberName", "checkstyle:visibilitymodifier"})
public class LogCmdRecord extends LogRecord {
    public Timestamp log_time;

    public long uid;
    public String role;
    @LogField(hidden = true)
    public long[] client_id;
    public long[] cluid;
    public long[] cid;
    @LogField(hidden = true)
    public long[] pid;

    public String service;
    public String cmd;

    public float runtime;
    @LogField(hidden = true)
    public float cpu_user_time;

    @LogField(heavy = true)
    public String param;

    @LogField(heavy = true, hidden = true, virtual = LogCmdParamsRawColumn.class)
    public String params_raw;

    public int http_status;

    @LogField(heavy = true)
    public String response;

    public String ip;
    @LogField(selective = true)
    public long reqid;
    public long trace_id;
    @LogField(hidden = true)
    public String host;
    @LogField(hidden = true)
    public long proc_id;
    @LogField(hidden = true)
    public String yandexuid;
    @LogField(hidden = true)
    public String source;
    @LogField(hidden = true)
    public int tvm_service_id;
    @LogField(hidden = true, virtual = TvmServiceNameColumn.class)
    public String tvm_service_name;
}
