package ru.yandex.direct.logviewercore.domain.ppclog;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import ru.yandex.direct.logviewercore.service.virtual.VirtualColumn;

/**
 * LogRecord field additional metadata
 */
@Documented
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface LogField {
    /**
     * Human-readable name of field
     *
     * @return
     */
    String desc() default "";

    /**
     * Название столбца в БД, по-умолчанию - название колонки
     *
     * @return
     */
    String columnName() default "";

    /**
     * Marks, that field can contain large data, so we needs to optimize queries
     *
     * @return
     */
    boolean heavy() default false;

    /**
     * Marks fields (one or many), that highly selective (almost unique) in table,
     * so we can use it for lateJoinOptimization
     *
     * @return
     */
    boolean selective() default false;

    /**
     * Условие по полю стоит выносить в prewhere
     */
    boolean prewhere() default false;

    /**
     * Don't show column in interface by default
     * (but user can choose it to show)
     *
     * @return
     */
    boolean hidden() default false;

    /**
     * Don't show column in interface
     * (user cannot choose it to show)
     *
     * @return
     */
    boolean strictlyHidden() default false;

    /**
     * Значение умножено на число, при показе нужно на него разделить и привести к double
     *
     * @return
     */
    int scale() default 0;

    Class<? extends VirtualColumn> virtual() default VirtualColumn.class;
}
