package ru.yandex.direct.logviewercore.domain.ppclog;

import java.sql.Timestamp;

@LogTable(
        tableName = "messages",
        logName = "messages",
        reqidColumn = "span_id",
        traceIdColumn = "trace_id",
        desc = "New-style messages of all direct systems",
        additionalSort = {"log_time_nanos"}
)
@SuppressWarnings({"MemberName", "checkstyle:visibilitymodifier"})
public class LogMessages extends LogRecord {
    public Timestamp log_time;
    @LogField(hidden = true)
    public long log_time_nanos;

    public String host;
    public String service;
    public String method;

    public long trace_id;
    @LogField(hidden = true)
    public long parent_id;
    public long span_id;

    public String prefix;
    public String log_level;
    public String class_name;

    public String message;
}
