package ru.yandex.direct.logviewercore.domain.ppclog;

import java.sql.Timestamp;

import ru.yandex.direct.logviewercore.service.virtual.KeywordTextColumn;

@LogTable(
        tableName = "ppclog_price",
        logName = "ppclog_price",
        reqidColumn = "reqid"
)
@SuppressWarnings({"MemberName", "checkstyle:visibilitymodifier"})
public class LogPriceRecord extends LogRecord {
    public Timestamp log_time;
    public String service;
    public String method;
    public long reqid;
    public long uid;
    @LogField(hidden = true)
    public String host;
    public String ip;
    @LogField(prewhere = true)
    public long cid;
    @LogField(prewhere = true)
    public long pid;
    public long id;
    @LogField(virtual = KeywordTextColumn.class)
    public String phrase;
    public String type;
    public String currency;
    public float price;
    public float price_ctx;
}
