package ru.yandex.direct.logviewercore.domain.ppclog;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Данной аннотацией помечается название ClickHouse таблицы
 */
@Documented
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface LogTable {
    String SCOPE_DIRECT = "DIRECT";
    String SCOPE_GRUT = "GRUT";

    /**
     * Name of table (system information)
     */
    String tableName();

    /**
     * Name of log (visible in web interfaces)
     */
    String logName();

    /**
     * Description of log
     */
    String desc() default "";

    /**
     * Some tables have text data with broken encoding (twice encoded to UTF8)
     */
    boolean encodingBroken() default false;

    /**
     * Название слолбца, в котором хранится дата/время
     */
    String logTimeColumn() default "log_time";

    /**
     * Название слолбца, в котором хранится дата/время
     */
    String logDateColumn() default "log_date";

    /**
     * Название столбца, с которым нужно array-join-ить таблицу
     */
    String arrayJoin() default "";

    /**
     * В дополнение к logTimeColumn, нужно сортировать по этим столбцам
     */
    String[] additionalSort() default {};

    /**
     * Столбец с reqid/span_id - идентификатор внешнего запроса
     */
    String reqidColumn() default "";

    /**
     * Столбец с traceId - идентификатор запроса более высокого уровня
     * Если определена данная аннотация, то ответ дополнится записями, имеющие такой же traceId
     */
    String traceIdColumn() default "";

    /**
     * Список систем, к которым относится этот лог
     * По умолчанию SCOPE_DIRECT, такие логи могут просматриваться всеми пользователями Директа, у которых
     * есть роль на доступ в логвьювер.
     */
    String[] allowAccessFor() default {SCOPE_DIRECT};
}
