package ru.yandex.direct.logviewercore.domain.ppclog;

import java.sql.Timestamp;

import ru.yandex.direct.logviewercore.service.virtual.MetricsContextObjectColumn;

@LogTable(tableName = "metrics",
        logTimeColumn = "log_time",
        logDateColumn = "log_date",
        reqidColumn = "reqid",
        desc = "Лог данных различных метрик",
        logName = "metrics"
)
@SuppressWarnings({"MemberName", "checkstyle:visibilitymodifier"})
public class Metrics extends LogRecord {
    public Timestamp log_time;

    @LogField(hidden = true)
    public String service;
    @LogField(hidden = true)
    public String method;

    @LogField(hidden = true)
    public String host;
    @LogField(hidden = true)
    public String ip;

    public long reqid;

    public String metric_name;

    public double metric_value;

    @LogField(columnName = "context.key", hidden = true)
    public String[] context_object_attr;

    @LogField(columnName = "context.value", hidden = true)
    public String[] context_object_value;

    @LogField(virtual = MetricsContextObjectColumn.class)
    public String context_object;
}
