package ru.yandex.direct.logviewercore.domain.ppclog;

import java.sql.Timestamp;

@LogTable(
        tableName = "mysql_slow_query_log",
        logName = "mysql_slow_query_log",
        desc = "MySQL slow queries logs",
        logTimeColumn = "query_time",
        logDateColumn = "query_date",
        reqidColumn = "query_request_id",
        additionalSort = {"query_id_in_timestamp", "cluster_id"}
)

@SuppressWarnings({"MemberName", "checkstyle:visibilitymodifier"})
public class MysqlSlowLogs extends LogRecord {
    @LogField(columnName = "query_time")
    public Timestamp log_time;

    @LogField(hidden = true)
    public String cluster_id;

    public String cluster_name;

    @LogField(hidden = true)
    public int cluster_version;

    @LogField(hidden = true)
    public int query_id_in_timestamp;

    @LogField(hidden = true, heavy = true)
    public String query_normal_form;

    @LogField(columnName = "query_service")
    public String service;

    @LogField(columnName = "query_method")
    public String method;

    @LogField(columnName = "query_text", heavy = true)
    public String query;

    @LogField(columnName = "query_time_in_seconds")
    public double query_time;

    @LogField(columnName = "lock_time_in_seconds", hidden = true)
    public double lock_time;

    public long rows_sent;

    @LogField(hidden = true)
    public long rows_examined;

    @LogField(hidden = true)
    public long rows_affected;

    @LogField(columnName = "bytes_sent", desc = "megabytes_sent", scale = 1024 * 1024)
    public long megabytes_sent;

    @LogField(columnName = "query_request_id", desc = "reqid")
    public long reqid;

    @LogField(hidden = true)
    public String user_name;

    @LogField(hidden = true)
    public String user_second_name;

    @LogField(hidden = true)
    public String user_host;

    @LogField(hidden = true)
    public String user_ip;

    @LogField(hidden = true)
    public long connection_id;

    @LogField(hidden = true)
    public String schema_name;

    @LogField(hidden = true)
    public int last_error_number;

    @LogField(hidden = true)
    public int killed_code;

    @LogField(hidden = true)
    public int temp_tables_count;

    @LogField(hidden = true)
    public int temp_tables_on_disk_count;

    @LogField(hidden = true)
    public long temp_tables_sizes_in_bytes;

    @LogField(hidden = true)
    public long transaction_id;

    @LogField(hidden = true)
    public boolean has_qc_hit;

    @LogField(hidden = true)
    public boolean has_full_scan;

    @LogField(hidden = true)
    public boolean has_full_join;

    @LogField(hidden = true)
    public boolean has_temp_tables;

    @LogField(hidden = true)
    public boolean has_temp_tables_on_disk;

    @LogField(hidden = true)
    public boolean has_file_sort;

    @LogField(hidden = true)
    public boolean has_file_sort_on_disk;

    @LogField(hidden = true)
    public int merge_passes_count;

    @LogField(hidden = true)
    public int inno_db_io_reads_count;

    @LogField(hidden = true)
    public long inno_db_io_read_bytes_count;

    @LogField(hidden = true)
    public double inno_db_read_wait_in_seconds;

    @LogField(hidden = true)
    public double inno_db_records_lock_wait_in_seconds;

    @LogField(hidden = true)
    public double inno_db_queue_wait_in_seconds;

    @LogField(hidden = true)
    public int inno_db_pages_count_distinct;

    @LogField(hidden = true)
    public String raw_record_text;
}
