package ru.yandex.direct.logviewercore.domain.ppclog;

import java.sql.Timestamp;

@LogTable(
        tableName = "nginx_access",
        logName = "nginx_access",
        reqidColumn = "upstream_reqid",
        desc = "Nginx access logs"
)
@SuppressWarnings({"MemberName", "checkstyle:visibilitymodifier"})
public class NginxAccessRecord extends LogRecord {
    public Timestamp log_time;

    public String remote_addr;

    public String vhost;

    @LogField(columnName = "request_type")
    public String method;

    @LogField(columnName = "request_url")
    public String req_uri;

    @LogField(columnName = "request_potocol", hidden = true)
    public String req_protocol;

    public int status;

    @LogField(columnName = "request_time")
    public double time;
    @LogField(columnName = "upstream_response_time")
    public double[] upstream_time;
    @LogField(columnName = "body_bytes_sent")
    public int resp_size;

    @LogField(hidden = true)
    public String upstream_service;
    @LogField(hidden = true)
    public String upstream_method;
    public long upstream_reqid;

    @LogField(hidden = true)
    public String http_referer;
    @LogField(hidden = true)
    public String http_user_agent;
    @LogField(hidden = true)
    public String http_host;

    @LogField(hidden = true)
    public int server_port;

    @LogField(hidden = true)
    public String ssl_protocol;
    @LogField(hidden = true)
    public String ssl_cipher;

    public String hostname;

    @LogField(hidden = true)
    public String upstream_http_x_accel_uid;

    @LogField(columnName = "upstream_var.name", hidden = true)
    public String[] upstream_var_name;

    @LogField(columnName = "upstream_var.value", hidden = true)
    public String[] upstream_var_value;
}
