package ru.yandex.direct.logviewercore.domain.ppclog;

import java.sql.Timestamp;

import ru.yandex.direct.logviewercore.service.virtual.TraceProfileFieldsColumn;

@LogTable(tableName = "trace",
        reqidColumn = "span_id",
        traceIdColumn = "trace_id",
        logName = "trace"

)
@SuppressWarnings({"MemberName", "checkstyle:visibilitymodifier"})
public class TraceRecord extends LogRecord {
    public Timestamp log_time;

    @LogField(hidden = true)
    public long format_id;

    @LogField(hidden = true)
    public String host;
    public String service;
    public String method;
    public String tags;

    public long trace_id;
    @LogField(hidden = true)
    public long parent_id;

    public long span_id;

    @LogField(hidden = true)
    public long chunk_index;
    @LogField(hidden = true)
    public int chunk_last;

    @LogField(hidden = true)
    public double span_time;

    @LogField(hidden = true)
    public long samplerate;

    public double ela;
    public double cpu_user;

    @LogField(hidden = true)
    public double cpu_system;
    @LogField(hidden = true)
    public double mem;

    @LogField(columnName = "profile.func", hidden = true)
    public String[] profile_func;

    @LogField(columnName = "profile.tags", hidden = true)
    public String[] profile_tags;

    @LogField(columnName = "profile.all_ela", hidden = true)
    public double[] profile_all_ela;

    @LogField(columnName = "profile.childs_ela", hidden = true)
    public double[] profile_childs_ela;

    @LogField(columnName = "profile.calls", hidden = true)
    public int[] profile_calls;

    @LogField(columnName = "profile.obj_num", hidden = true)
    public int[] profile_obj_num;

    @LogField(virtual = TraceProfileFieldsColumn.class)
    public String profile;

    @LogField(columnName = "services.service", hidden = true)
    public String[] services_service;

    @LogField(columnName = "services.method", hidden = true)
    public String[] services_method;

    @LogField(columnName = "services.span_id", hidden = true)
    public long[] services_span_id;

    @LogField(columnName = "services.rel_client_send", hidden = true)
    public double[] services_rel_client_send;

    @LogField(columnName = "services.ela", hidden = true)
    public double[] services_ela;

    @LogField(columnName = "marks.relative_time", hidden = true)
    public double[] marks_relative_time;

    @LogField(columnName = "marks.message", hidden = true)
    public String[] marks_message;

    @LogField(columnName = "annotations.key", hidden = true)
    public String[] annotations_key;

    @LogField(columnName = "annotations.value", hidden = true)
    public String[] annotations_value;
}
