package ru.yandex.direct.logviewercore.domain.web;

import ru.yandex.direct.logviewercore.repository.LogviewerHistoryRow;

public class HistoryItem {
    private final String queryId;
    private final String name;
    private final String logName;
    private final Status status;
    private final boolean isFavourite;
    private final long startTime;
    private final int executionTime;
    private final LogViewerFilterForm request;
    private final FilterResponse response;

    public static HistoryItem createInstance(LogviewerHistoryRow row) {
        if (row == null) {
            return null;
        }
        return new HistoryItem(
                row.getQueryId(), row.getName(), row.getTemplate(), row.getStatus(), row.isFavourite(),
                row.getStartTime(), row.getExecutionTime(), row.getRequest(), row.getResponse()
        );
    }

    private HistoryItem(
            String queryId, String name, String logName, Status status, boolean isFavourite,
            long startTime, int executionTime, LogViewerFilterForm request, FilterResponse response
    ) {
        this.queryId = queryId;
        this.name = name;
        this.logName = logName;
        this.status = status;
        this.isFavourite = isFavourite;
        this.startTime = startTime;
        this.executionTime = executionTime;
        this.request = request;
        this.response = response;
    }

    public String getQueryId() {
        return queryId;
    }

    public String getName() {
        return name;
    }

    public String getLogName() {
        return logName;
    }

    public Status getStatus() {
        return status;
    }

    public boolean isFavourite() {
        return isFavourite;
    }

    public long getStartTime() {
        return startTime;
    }

    public int getExecutionTime() {
        return executionTime;
    }

    public LogViewerFilterForm getRequest() {
        return request;
    }

    public FilterResponse getResponse() {
        return response;
    }

    public enum Status {
        OK, FAIL, RUNNING, UNKNOWN
    }
}
