package ru.yandex.direct.logviewercore.domain.web;

import java.util.List;

/**
 * Data-class for information about known log types
 */
public class InfoResponse {
    /**
     * List of known log types
     */
    private final List<LogInfo> logs;

    public InfoResponse(List<LogInfo> logs) {
        this.logs = logs;
    }

    /**
     * Data-class for information about one concrete log type
     */
    public static class LogInfo {
        /**
         * Name of log
         */
        private final String name;

        /**
         * Description of log
         */
        private final String desc;

        /**
         * List of columns
         */
        private final List<ColumnInfo> columns;

        private final String reqidColumn;

        private final String traceIdColumn;

        public LogInfo(String name, String desc, String reqidColumn, String traceIdColumn, List<ColumnInfo> columns) {
            this.name = name;
            this.desc = desc;
            this.reqidColumn = reqidColumn;
            this.traceIdColumn = traceIdColumn;
            this.columns = columns;
        }

        public List<ColumnInfo> getColumns() {
            return columns;
        }

        public String getDesc() {
            return desc;
        }

        public String getName() {
            return name;
        }

        public String getReqidColumn() {
            return reqidColumn;
        }

        public String getTraceIdColumn() {
            return traceIdColumn;
        }
    }

    /**
     * Data-class for information about column
     */
    public static class ColumnInfo {
        /**
         * Name of column
         */
        private final String name;

        /**
         * Human-readable name of column
         */
        private final String desc;

        /**
         * Column is hidden in interface by default
         */
        private final boolean hidden;
        /**
         * Column is strictly hidden in interface
         */
        private final boolean strictlyHidden;
        /**
         * Column is heavy (can contain a lot of data)
         */
        private final boolean heavy;

        private final int scale;

        /**
         * Является ли столбец вычислимым
         */
        private final boolean virtual;

        public ColumnInfo(
                String name,
                String desc,
                boolean hidden,
                boolean strictlyHidden,
                boolean heavy,
                int scale,
                boolean virtual
        ) {
            this.name = name;
            this.desc = desc;
            this.hidden = hidden;
            this.strictlyHidden = strictlyHidden;
            this.heavy = heavy;
            this.scale = scale;
            this.virtual = virtual;
        }

        public String getDesc() {
            return desc;
        }

        public boolean isHeavy() {
            return heavy;
        }

        public boolean isHidden() {
            return hidden;
        }

        public boolean isStrictlyHidden() {
            return strictlyHidden;
        }

        public String getName() {
            return name;
        }

        public int getScale() {
            return scale;
        }

        public boolean isVirtual() {
            return virtual;
        }
    }

    public List<LogInfo> getLogs() {
        return logs;
    }
}
