package ru.yandex.direct.logviewercore.domain.web;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Maps;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class LogViewerFilterForm {
    private LocalDateTime from;
    private LocalDateTime to;
    private List<String> fields;
    private Map<String, String> conditions;
    private boolean showStats;
    private TimeGroupingType logTimeGroupBy;
    private boolean sortByCount;
    private boolean showTraceIdRelated;
    private boolean reverseOrder;
    private int limit;
    private int offset;

    public enum TimeGroupingType {
        YEAR, MONTH, DAY, HOUR, MINUTE;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    public LocalDateTime getFrom() {
        return from;
    }

    public void setFrom(LocalDateTime from) {
        this.from = from;
    }

    public LocalDateTime getTo() {
        return to;
    }

    public void setTo(LocalDateTime to) {
        this.to = to;
    }

    public List<String> getFields() {
        return fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public Map<String, String> getConditions() {
        return Maps.transformValues(conditions, v -> v.trim());
    }

    public void setConditions(Map<String, String> conditions) {
        this.conditions = conditions;
    }

    public boolean isShowStats() {
        return showStats;
    }

    public void setShowStats(boolean showStats) {
        this.showStats = showStats;
    }

    public TimeGroupingType getLogTimeGroupBy() {
        return logTimeGroupBy;
    }

    public void setLogTimeGroupBy(TimeGroupingType logTimeGroupBy) {
        this.logTimeGroupBy = logTimeGroupBy;
    }

    public boolean isSortByCount() {
        return sortByCount;
    }

    public void setSortByCount(boolean sortByCount) {
        this.sortByCount = sortByCount;
    }

    public boolean isShowTraceIdRelated() {
        return showTraceIdRelated;
    }

    public void setShowTraceIdRelated(boolean showTraceIdRelated) {
        this.showTraceIdRelated = showTraceIdRelated;
    }

    public boolean isReverseOrder() {
        return reverseOrder;
    }

    public void setReverseOrder(boolean reverseOrder) {
        this.reverseOrder = reverseOrder;
    }

    public int getLimit() {
        return limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getOffset() {
        return offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }
}
