package ru.yandex.direct.logviewercore.repository;

import java.util.List;

import com.yandex.ydb.table.values.PrimitiveType;

import ru.yandex.direct.ydb.column.Column;
import ru.yandex.direct.ydb.table.Table;

import static com.yandex.ydb.table.values.PrimitiveType.bool;
import static com.yandex.ydb.table.values.PrimitiveType.int32;
import static com.yandex.ydb.table.values.PrimitiveType.string;
import static com.yandex.ydb.table.values.PrimitiveType.uint64;
import static com.yandex.ydb.table.values.PrimitiveType.utf8;

@SuppressWarnings({"all"})
public class LogviewerHistory extends Table {
    private static final String TABLE_NAME = "logviewer_history";

    public final Column<Long> QUERY_ID = new Column<Long>(this, "query_id", uint64()).pk();
    public final Column<Integer> LIMIT = new Column<Integer>(this, "limit", int32()).pk();
    public final Column<Integer> OFFSET = new Column<Integer>(this, "offset", int32()).pk();
    public final Column<Long> CLIENT_ID = new Column<Long>(this, "client_id", uint64()).pk();
    public final Column<byte[]> COMPRESSED_RESPONSE = new Column<>(this, "compressed_response", string());
    public final Column<Integer> EXECUTION_TIME = new Column<>(this, "execution_time", int32());
    public final Column<Boolean> FAVOURITE = new Column<>(this, "favourite", bool());
    public final Column<String> NAME = new Column<>(this, "name", utf8());
    public final Column<Boolean> PERSISTENT = new Column<>(this, "persistent", bool());
    public final Column<String> REQUEST = new Column<>(this, "request", PrimitiveType.json());
    public final Column<Long> START_TIME = new Column<>(this, "start_time", uint64());
    public final Column<String> STATUS = new Column<>(this, "status", utf8());
    public final Column<String> TEMPLATE = new Column<>(this, "template", utf8());
    public final Column<Integer> VERSION = new Column<>(this, "version", int32());

    private final List<Column> COLUMNS = List.of(
            QUERY_ID, LIMIT, OFFSET, CLIENT_ID, START_TIME,
            COMPRESSED_RESPONSE, EXECUTION_TIME, FAVOURITE, NAME, PERSISTENT, REQUEST, STATUS, TEMPLATE, VERSION);

    public LogviewerHistory() {
        super(TABLE_NAME);
    }

    private LogviewerHistory(String alias) {
        super(TABLE_NAME, alias);
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }
}
