package ru.yandex.direct.logviewercore.repository;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.logviewercore.domain.web.FilterResponse;
import ru.yandex.direct.logviewercore.domain.web.HistoryItem;
import ru.yandex.direct.logviewercore.domain.web.LogViewerFilterForm;
import ru.yandex.direct.utils.JsonUtils;
import ru.yandex.direct.utils.compress.GzipUtils;

public class LogviewerHistoryRow {
    Long queryId;
    Integer limit;
    Integer offset;
    Long clientId;
    byte[] compressedResponse = new byte[]{};
    Integer executionTime = 0;
    Boolean favourite;
    String name = "NO_NAME";
    Boolean persistent;
    String request = "";
    Long startTime;
    String status = "RUNNING";
    String template = "";
    Integer version = 1;

    public String getQueryId() {
        return queryId == null ? null : queryId.toString();
    }

    public long getLimit() {
        return limit == null ? 0 : limit;
    }

    public long getOffset() {
        return offset == null ? 0 : offset;
    }

    public String getName() {
        return name == null ? "NO_NAME" : name;
    }

    public String getTemplate() {
        return template;
    }

    public HistoryItem.Status getStatus() {
        return status == null ? null : HistoryItem.Status.valueOf(status);
    }

    public long getStartTime() {
        return startTime == null ? 0 : startTime;
    }

    public int getExecutionTime() {
        return executionTime == null ? 0 : executionTime;
    }

    public boolean isFavourite() {
        return favourite == null ? false : favourite;
    }

    public LogViewerFilterForm getRequest() {
        return StringUtils.isEmpty(request) ? null : JsonUtils.fromJson(request, LogViewerFilterForm.class);
    }

    public FilterResponse getResponse() {
        return compressedResponse == null || compressedResponse.length == 0 ?
                null :
                JsonUtils.fromJson(GzipUtils.decompress(compressedResponse), FilterResponse.class);
    }

    public static LogviewerHistoryRow createStartedRow(
            Long queryId, String logName, ClientId clientId,
            LogViewerFilterForm form, long startTime) {
        return createRow(
                queryId, logName, clientId, HistoryItem.Status.RUNNING,
                form, null, startTime, 0);
    }

    public static LogviewerHistoryRow createFinishedRow(
            Long queryId, String logName, ClientId clientId,
            LogViewerFilterForm form, FilterResponse response,
            long startTime, int executionTime) {
        return createRow(queryId, logName, clientId, toStatus(response), form, response, startTime, executionTime);
    }

    private static LogviewerHistoryRow createRow(
            Long queryId, String logName, ClientId clientId, HistoryItem.Status status,
            LogViewerFilterForm form, FilterResponse response,
            long startTime, int executionTime) {
        LogviewerHistoryRow row = new LogviewerHistoryRow();
        row.queryId = queryId;
        row.limit = form.getLimit();
        row.offset = form.getOffset();
        row.clientId = clientId == null ? 0 : clientId.asLong();
        row.startTime = startTime;
        row.executionTime = executionTime;
        row.template = logName;
        row.name = toName(logName, form);
        row.status = status.toString();
        row.request = JsonUtils.toJson(form);
        row.compressedResponse = GzipUtils.compressString(JsonUtils.toJson(response));
        row.persistent = false;
        row.favourite = false;
        row.version = 1;
        return row;
    }

    private static HistoryItem.Status toStatus(FilterResponse response) {
        if (response == null) {
            return HistoryItem.Status.UNKNOWN;
        }
        if (response.getError() != null) {
            return HistoryItem.Status.FAIL;
        }
        return HistoryItem.Status.OK;
    }

    private static String toName(String logName, LogViewerFilterForm form) {
        StringBuilder name = new StringBuilder(logName);
        int offset = form.getOffset();
        if (offset > 0) {
            name.append(" [")
                    .append(offset + 1)
                    .append("-")
                    .append(offset + form.getLimit())
                    .append("]");
        }
        return name.toString();
    }
}
