package ru.yandex.direct.logviewercore.service.virtual;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.api.application.repository.ApiApplicationCertificationRequestRepository;
import ru.yandex.direct.logviewercore.domain.ppclog.LogApiRecord;

/**
 * по id приложения api получаем его имя
 */
@Component
public class ApplicationNameColumn implements VirtualColumn<LogApiRecord, String> {
    private final ApiApplicationCertificationRequestRepository appRepos;

    @Autowired
    public ApplicationNameColumn(ApiApplicationCertificationRequestRepository appRepos) {
        this.appRepos = appRepos;
    }

    @Override
    public String[] sourceColumns() {
        return new String[]{"application_id"};
    }

    @Override
    public void calculate(List<LogApiRecord> recs) {
        List<String> ids = StreamEx.of(recs)
                .map(r -> r.application_id)
                .filter(Objects::nonNull)
                .filter(s -> !s.isEmpty())
                .distinct()
                .toList();
        Map<String, String> names = appRepos.getApplicationsNames(ids);

        for (LogApiRecord rec : recs) {
            Optional.ofNullable(rec.application_id)
                    .map(names::get)
                    .ifPresent(name -> rec.application_name = name);
        }
    }
}
