package ru.yandex.direct.logviewercore.service.virtual;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.springframework.stereotype.Component;

import ru.yandex.direct.logviewercore.domain.ppclog.BinlogRowsV2;

/**
 * Красивое форматирование данных бинлога
 */
@Component
public class BinlogFieldsColumnV2 implements VirtualColumn<BinlogRowsV2, String> {
    private static final ObjectMapper MAPPER = new ObjectMapper()
            .enable(
                    SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS,
                    SerializationFeature.WRITE_NULL_MAP_VALUES
            );

    @Override
    public String[] sourceColumns() {
        return new String[]{"col_name", "col_value", "col_is_null"};
    }

    @Override
    public void calculate(List<BinlogRowsV2> recs) {
        for (BinlogRowsV2 rec : recs) {
            Map<String, Object> data = new HashMap<>();
            for (int i = 0; i < rec.col_name.length; i++) {
                Object val = null;
                if (Objects.equals(rec.col_is_null[i], "FALSE")) {
                    val = rec.col_value[i];
                    try {
                        val = Long.parseLong(rec.col_value[i]);
                    } catch (NumberFormatException e) {
                        // pass
                    }
                }
                data.put(rec.col_name[i], val);
            }
            try {
                rec.row = MAPPER.writeValueAsString(data);
            } catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Error while json serialization", e);
            }
        }
    }
}
