package ru.yandex.direct.logviewercore.service.virtual;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.springframework.stereotype.Component;

import ru.yandex.direct.logviewercore.domain.ppclog.EssLogicObjects;

@Component
public class EssLogicObjectColumn implements VirtualColumn<EssLogicObjects, String> {
    private static final ObjectMapper MAPPER = new ObjectMapper()
            .enable(
                    SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS
            );

    @Override
    public String[] sourceColumns() {
        return new String[]{"logic_object_attr", "logic_object_value"};
    }

    @Override
    public void calculate(List<EssLogicObjects> objects) {
        for (EssLogicObjects object : objects) {
            Map<String, Object> data = new HashMap<>();
            for (int i = 0; i < object.logic_object_attr.length; i++) {
                data.put(object.logic_object_attr[i], object.logic_object_value[i]);
            }
            try {
                object.logic_object = MAPPER.writeValueAsString(data);
            } catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Error while json serialization", e);
            }
        }

    }
}

