package ru.yandex.direct.logviewercore.service.virtual;

import java.util.List;

import com.google.common.base.Strings;
import org.springframework.stereotype.Component;

import ru.yandex.direct.logviewercore.domain.ppclog.JavaThreaddumpThread;

@Component
public class JavaThreaddumpThreadStacktraceColumn implements VirtualColumn<JavaThreaddumpThread, String> {
    @Override
    public String[] sourceColumns() {
        return new String[]{"thread_header", "thread_state", "thread_stacktrace"};
    }

    @Override
    public void calculate(List<JavaThreaddumpThread> recs) {
        for (JavaThreaddumpThread rec : recs) {
            rec.full_stacktrace = formatFullThreadStacktrace(
                    rec.thread_header, rec.thread_state, rec.thread_stacktrace
            );
        }
    }

    public static String formatFullThreadStacktrace(String header, String state, String stacktrace) {
        var sb = new StringBuilder(header);

        if (!Strings.isNullOrEmpty(state)) {
            sb.append('\n').append("   java.lang.Thread.State: ").append(state);
            if (!Strings.isNullOrEmpty(stacktrace)) {
                sb.append('\n').append(stacktrace);
            }
        }

        return sb.toString();
    }
}
