package ru.yandex.direct.logviewercore.service.virtual;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.keyword.model.KeywordText;
import ru.yandex.direct.core.entity.keyword.repository.KeywordRepository;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.sharding.ShardKey;
import ru.yandex.direct.logviewercore.domain.ppclog.LogPriceRecord;

import static ru.yandex.direct.utils.FunctionalUtils.flatMap;
import static ru.yandex.direct.utils.FunctionalUtils.listToMap;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * По id кампании и фразы получаем её текст
 */
@Component
public class KeywordTextColumn implements VirtualColumn<LogPriceRecord, String> {
    private final ShardHelper shardHelper;
    private final KeywordRepository keywordRepository;

    @Autowired
    public KeywordTextColumn(ShardHelper shardHelper, KeywordRepository keywordRepository) {
        this.shardHelper = shardHelper;
        this.keywordRepository = keywordRepository;
    }

    @Override
    public String[] sourceColumns() {
        return new String[]{"cid", "id"};
    }

    @Override
    public void calculate(List<LogPriceRecord> recs) {
        shardHelper.groupByShard(recs, ShardKey.CID, r -> r.cid)
                .forEach((shard, chunk) -> {
                    Map<Long, List<KeywordText>> keywordTextsByCampaignIds =
                            keywordRepository.getKeywordTextsByCampaignIds(shard, null, mapList(chunk, r -> r.cid));
                    Map<Long, String> id2phrase =
                            listToMap(flatMap(keywordTextsByCampaignIds.values(), w -> w),
                                    w -> w.getId(), w -> w.getPhrase());
                    for (LogPriceRecord rec : chunk) {
                        rec.phrase = id2phrase.get(rec.id);
                    }
                });
    }
}
