package ru.yandex.direct.logviewercore.service.virtual;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.logviewercore.domain.ppclog.LogCmdRecord;

@Component
public class LogCmdParamsRawColumn implements VirtualColumn<LogCmdRecord, String> {
    @Override
    public String[] sourceColumns() {
        return new String[]{"param"};
    }

    @Override
    public void calculate(List<LogCmdRecord> recs) {
        recs.forEach(element -> element.params_raw = element.param);
    }
}
