package ru.yandex.direct.logviewercore.service.virtual;

import java.util.HashMap;
import java.util.List;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.springframework.stereotype.Component;

import ru.yandex.direct.logviewercore.domain.ppclog.Metrics;

@Component
public class MetricsContextObjectColumn implements VirtualColumn<Metrics, String> {
    private static final ObjectMapper MAPPER = new ObjectMapper()
            .enable(
                    SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS
            );

    @Override
    public String[] sourceColumns() {
        return new String[]{"context_object_attr", "context_object_value"};
    }

    @Override
    public void calculate(List<Metrics> metrics) {
        for (var metric : metrics) {
            var data = new HashMap<String, Object>();
            for (int i = 0; i < metric.context_object_attr.length; i++) {
                data.put(metric.context_object_attr[i], metric.context_object_value[i]);
            }
            try {
                metric.context_object = MAPPER.writeValueAsString(data);
            } catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Error while json serialization", e);
            }
        }
    }
}
