package ru.yandex.direct.logviewercore.service.virtual;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.logviewercore.domain.ppclog.LogCmdRecord;
import ru.yandex.direct.tvm.TvmService;

/**
 * по id tvm сервиса получаем его имя
 */
@Component
public class TvmServiceNameColumn implements VirtualColumn<LogCmdRecord, String> {

    @Override
    public String[] sourceColumns() {
        return new String[]{"tvm_service_id"};
    }

    @Override
    public void calculate(List<LogCmdRecord> recs) {
        recs.forEach(rec -> rec.tvm_service_name = TvmService.fromId(rec.tvm_service_id).name());
    }
}
